#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;

#endregion



#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		
		private MillaPro[] cacheMillaPro;
		private AuSuperSmootherFilter[] cacheAuSuperSmootherFilter;

		
		public MillaPro MillaPro(string chartSetupTip, NinjaTrader.NinjaScript.Indicators.TradingMode selectedMode, int stopLoss, double stopLoss_To_Profit_Target_Ratio, int maxWaitBars, bool enableDotFlipS3, int s3MinGapBars, int s3MaxGapBars, bool enableDotCrossStrategy, int firstCandleMaxDistance, int alignWindowBars, NinjaTrader.NinjaScript.Indicators.ValidationMode validationModeSelection, bool enableValidationAsEntry, bool useValAsEntry_Opt2_TrendStrengthOnly, bool useValAsEntry_Opt1_CanTradeOnly, bool useValAsEntry_Opt3_Both_LastLegWins, bool useTSFilter, int minBullPctForLong, int minBearPctForShort, bool enableExitAlerts, int exitThreshold, int exitCooldownBars, bool useAutoOW, int manualBreakoutCushionTicks, int manualHoldBarsAfterBreakout, int manualCooldownBarsAfterFlip, bool useLimitPullbackEntry, int pullbackTicks, int uiFontSize)
		{
			return MillaPro(Input, chartSetupTip, selectedMode, stopLoss, stopLoss_To_Profit_Target_Ratio, maxWaitBars, enableDotFlipS3, s3MinGapBars, s3MaxGapBars, enableDotCrossStrategy, firstCandleMaxDistance, alignWindowBars, validationModeSelection, enableValidationAsEntry, useValAsEntry_Opt2_TrendStrengthOnly, useValAsEntry_Opt1_CanTradeOnly, useValAsEntry_Opt3_Both_LastLegWins, useTSFilter, minBullPctForLong, minBearPctForShort, enableExitAlerts, exitThreshold, exitCooldownBars, useAutoOW, manualBreakoutCushionTicks, manualHoldBarsAfterBreakout, manualCooldownBarsAfterFlip, useLimitPullbackEntry, pullbackTicks, uiFontSize);
		}

		public AuSuperSmootherFilter AuSuperSmootherFilter(int poles, int period)
		{
			return AuSuperSmootherFilter(Input, poles, period);
		}


		
		public MillaPro MillaPro(ISeries<double> input, string chartSetupTip, NinjaTrader.NinjaScript.Indicators.TradingMode selectedMode, int stopLoss, double stopLoss_To_Profit_Target_Ratio, int maxWaitBars, bool enableDotFlipS3, int s3MinGapBars, int s3MaxGapBars, bool enableDotCrossStrategy, int firstCandleMaxDistance, int alignWindowBars, NinjaTrader.NinjaScript.Indicators.ValidationMode validationModeSelection, bool enableValidationAsEntry, bool useValAsEntry_Opt2_TrendStrengthOnly, bool useValAsEntry_Opt1_CanTradeOnly, bool useValAsEntry_Opt3_Both_LastLegWins, bool useTSFilter, int minBullPctForLong, int minBearPctForShort, bool enableExitAlerts, int exitThreshold, int exitCooldownBars, bool useAutoOW, int manualBreakoutCushionTicks, int manualHoldBarsAfterBreakout, int manualCooldownBarsAfterFlip, bool useLimitPullbackEntry, int pullbackTicks, int uiFontSize)
		{
			if (cacheMillaPro != null)
				for (int idx = 0; idx < cacheMillaPro.Length; idx++)
					if (cacheMillaPro[idx].ChartSetupTip == chartSetupTip && cacheMillaPro[idx].SelectedMode == selectedMode && cacheMillaPro[idx].StopLoss == stopLoss && cacheMillaPro[idx].StopLoss_To_Profit_Target_Ratio == stopLoss_To_Profit_Target_Ratio && cacheMillaPro[idx].MaxWaitBars == maxWaitBars && cacheMillaPro[idx].EnableDotFlipS3 == enableDotFlipS3 && cacheMillaPro[idx].S3MinGapBars == s3MinGapBars && cacheMillaPro[idx].S3MaxGapBars == s3MaxGapBars && cacheMillaPro[idx].EnableDotCrossStrategy == enableDotCrossStrategy && cacheMillaPro[idx].FirstCandleMaxDistance == firstCandleMaxDistance && cacheMillaPro[idx].AlignWindowBars == alignWindowBars && cacheMillaPro[idx].ValidationModeSelection == validationModeSelection && cacheMillaPro[idx].EnableValidationAsEntry == enableValidationAsEntry && cacheMillaPro[idx].UseValAsEntry_Opt2_TrendStrengthOnly == useValAsEntry_Opt2_TrendStrengthOnly && cacheMillaPro[idx].UseValAsEntry_Opt1_CanTradeOnly == useValAsEntry_Opt1_CanTradeOnly && cacheMillaPro[idx].UseValAsEntry_Opt3_Both_LastLegWins == useValAsEntry_Opt3_Both_LastLegWins && cacheMillaPro[idx].UseTSFilter == useTSFilter && cacheMillaPro[idx].MinBullPctForLong == minBullPctForLong && cacheMillaPro[idx].MinBearPctForShort == minBearPctForShort && cacheMillaPro[idx].EnableExitAlerts == enableExitAlerts && cacheMillaPro[idx].ExitThreshold == exitThreshold && cacheMillaPro[idx].ExitCooldownBars == exitCooldownBars && cacheMillaPro[idx].UseAutoOW == useAutoOW && cacheMillaPro[idx].ManualBreakoutCushionTicks == manualBreakoutCushionTicks && cacheMillaPro[idx].ManualHoldBarsAfterBreakout == manualHoldBarsAfterBreakout && cacheMillaPro[idx].ManualCooldownBarsAfterFlip == manualCooldownBarsAfterFlip && cacheMillaPro[idx].UseLimitPullbackEntry == useLimitPullbackEntry && cacheMillaPro[idx].PullbackTicks == pullbackTicks && cacheMillaPro[idx].UiFontSize == uiFontSize && cacheMillaPro[idx].EqualsInput(input))
						return cacheMillaPro[idx];
			return CacheIndicator<MillaPro>(new MillaPro(){ ChartSetupTip = chartSetupTip, SelectedMode = selectedMode, StopLoss = stopLoss, StopLoss_To_Profit_Target_Ratio = stopLoss_To_Profit_Target_Ratio, MaxWaitBars = maxWaitBars, EnableDotFlipS3 = enableDotFlipS3, S3MinGapBars = s3MinGapBars, S3MaxGapBars = s3MaxGapBars, EnableDotCrossStrategy = enableDotCrossStrategy, FirstCandleMaxDistance = firstCandleMaxDistance, AlignWindowBars = alignWindowBars, ValidationModeSelection = validationModeSelection, EnableValidationAsEntry = enableValidationAsEntry, UseValAsEntry_Opt2_TrendStrengthOnly = useValAsEntry_Opt2_TrendStrengthOnly, UseValAsEntry_Opt1_CanTradeOnly = useValAsEntry_Opt1_CanTradeOnly, UseValAsEntry_Opt3_Both_LastLegWins = useValAsEntry_Opt3_Both_LastLegWins, UseTSFilter = useTSFilter, MinBullPctForLong = minBullPctForLong, MinBearPctForShort = minBearPctForShort, EnableExitAlerts = enableExitAlerts, ExitThreshold = exitThreshold, ExitCooldownBars = exitCooldownBars, UseAutoOW = useAutoOW, ManualBreakoutCushionTicks = manualBreakoutCushionTicks, ManualHoldBarsAfterBreakout = manualHoldBarsAfterBreakout, ManualCooldownBarsAfterFlip = manualCooldownBarsAfterFlip, UseLimitPullbackEntry = useLimitPullbackEntry, PullbackTicks = pullbackTicks, UiFontSize = uiFontSize }, input, ref cacheMillaPro);
		}

		public AuSuperSmootherFilter AuSuperSmootherFilter(ISeries<double> input, int poles, int period)
		{
			if (cacheAuSuperSmootherFilter != null)
				for (int idx = 0; idx < cacheAuSuperSmootherFilter.Length; idx++)
					if (cacheAuSuperSmootherFilter[idx].Poles == poles && cacheAuSuperSmootherFilter[idx].Period == period && cacheAuSuperSmootherFilter[idx].EqualsInput(input))
						return cacheAuSuperSmootherFilter[idx];
			return CacheIndicator<AuSuperSmootherFilter>(new AuSuperSmootherFilter(){ Poles = poles, Period = period }, input, ref cacheAuSuperSmootherFilter);
		}

	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		
		public Indicators.MillaPro MillaPro(string chartSetupTip, NinjaTrader.NinjaScript.Indicators.TradingMode selectedMode, int stopLoss, double stopLoss_To_Profit_Target_Ratio, int maxWaitBars, bool enableDotFlipS3, int s3MinGapBars, int s3MaxGapBars, bool enableDotCrossStrategy, int firstCandleMaxDistance, int alignWindowBars, NinjaTrader.NinjaScript.Indicators.ValidationMode validationModeSelection, bool enableValidationAsEntry, bool useValAsEntry_Opt2_TrendStrengthOnly, bool useValAsEntry_Opt1_CanTradeOnly, bool useValAsEntry_Opt3_Both_LastLegWins, bool useTSFilter, int minBullPctForLong, int minBearPctForShort, bool enableExitAlerts, int exitThreshold, int exitCooldownBars, bool useAutoOW, int manualBreakoutCushionTicks, int manualHoldBarsAfterBreakout, int manualCooldownBarsAfterFlip, bool useLimitPullbackEntry, int pullbackTicks, int uiFontSize)
		{
			return indicator.MillaPro(Input, chartSetupTip, selectedMode, stopLoss, stopLoss_To_Profit_Target_Ratio, maxWaitBars, enableDotFlipS3, s3MinGapBars, s3MaxGapBars, enableDotCrossStrategy, firstCandleMaxDistance, alignWindowBars, validationModeSelection, enableValidationAsEntry, useValAsEntry_Opt2_TrendStrengthOnly, useValAsEntry_Opt1_CanTradeOnly, useValAsEntry_Opt3_Both_LastLegWins, useTSFilter, minBullPctForLong, minBearPctForShort, enableExitAlerts, exitThreshold, exitCooldownBars, useAutoOW, manualBreakoutCushionTicks, manualHoldBarsAfterBreakout, manualCooldownBarsAfterFlip, useLimitPullbackEntry, pullbackTicks, uiFontSize);
		}

		public Indicators.AuSuperSmootherFilter AuSuperSmootherFilter(int poles, int period)
		{
			return indicator.AuSuperSmootherFilter(Input, poles, period);
		}


		
		public Indicators.MillaPro MillaPro(ISeries<double> input , string chartSetupTip, NinjaTrader.NinjaScript.Indicators.TradingMode selectedMode, int stopLoss, double stopLoss_To_Profit_Target_Ratio, int maxWaitBars, bool enableDotFlipS3, int s3MinGapBars, int s3MaxGapBars, bool enableDotCrossStrategy, int firstCandleMaxDistance, int alignWindowBars, NinjaTrader.NinjaScript.Indicators.ValidationMode validationModeSelection, bool enableValidationAsEntry, bool useValAsEntry_Opt2_TrendStrengthOnly, bool useValAsEntry_Opt1_CanTradeOnly, bool useValAsEntry_Opt3_Both_LastLegWins, bool useTSFilter, int minBullPctForLong, int minBearPctForShort, bool enableExitAlerts, int exitThreshold, int exitCooldownBars, bool useAutoOW, int manualBreakoutCushionTicks, int manualHoldBarsAfterBreakout, int manualCooldownBarsAfterFlip, bool useLimitPullbackEntry, int pullbackTicks, int uiFontSize)
		{
			return indicator.MillaPro(input, chartSetupTip, selectedMode, stopLoss, stopLoss_To_Profit_Target_Ratio, maxWaitBars, enableDotFlipS3, s3MinGapBars, s3MaxGapBars, enableDotCrossStrategy, firstCandleMaxDistance, alignWindowBars, validationModeSelection, enableValidationAsEntry, useValAsEntry_Opt2_TrendStrengthOnly, useValAsEntry_Opt1_CanTradeOnly, useValAsEntry_Opt3_Both_LastLegWins, useTSFilter, minBullPctForLong, minBearPctForShort, enableExitAlerts, exitThreshold, exitCooldownBars, useAutoOW, manualBreakoutCushionTicks, manualHoldBarsAfterBreakout, manualCooldownBarsAfterFlip, useLimitPullbackEntry, pullbackTicks, uiFontSize);
		}

		public Indicators.AuSuperSmootherFilter AuSuperSmootherFilter(ISeries<double> input , int poles, int period)
		{
			return indicator.AuSuperSmootherFilter(input, poles, period);
		}
	
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		
		public Indicators.MillaPro MillaPro(string chartSetupTip, NinjaTrader.NinjaScript.Indicators.TradingMode selectedMode, int stopLoss, double stopLoss_To_Profit_Target_Ratio, int maxWaitBars, bool enableDotFlipS3, int s3MinGapBars, int s3MaxGapBars, bool enableDotCrossStrategy, int firstCandleMaxDistance, int alignWindowBars, NinjaTrader.NinjaScript.Indicators.ValidationMode validationModeSelection, bool enableValidationAsEntry, bool useValAsEntry_Opt2_TrendStrengthOnly, bool useValAsEntry_Opt1_CanTradeOnly, bool useValAsEntry_Opt3_Both_LastLegWins, bool useTSFilter, int minBullPctForLong, int minBearPctForShort, bool enableExitAlerts, int exitThreshold, int exitCooldownBars, bool useAutoOW, int manualBreakoutCushionTicks, int manualHoldBarsAfterBreakout, int manualCooldownBarsAfterFlip, bool useLimitPullbackEntry, int pullbackTicks, int uiFontSize)
		{
			return indicator.MillaPro(Input, chartSetupTip, selectedMode, stopLoss, stopLoss_To_Profit_Target_Ratio, maxWaitBars, enableDotFlipS3, s3MinGapBars, s3MaxGapBars, enableDotCrossStrategy, firstCandleMaxDistance, alignWindowBars, validationModeSelection, enableValidationAsEntry, useValAsEntry_Opt2_TrendStrengthOnly, useValAsEntry_Opt1_CanTradeOnly, useValAsEntry_Opt3_Both_LastLegWins, useTSFilter, minBullPctForLong, minBearPctForShort, enableExitAlerts, exitThreshold, exitCooldownBars, useAutoOW, manualBreakoutCushionTicks, manualHoldBarsAfterBreakout, manualCooldownBarsAfterFlip, useLimitPullbackEntry, pullbackTicks, uiFontSize);
		}

		public Indicators.AuSuperSmootherFilter AuSuperSmootherFilter(int poles, int period)
		{
			return indicator.AuSuperSmootherFilter(Input, poles, period);
		}


		
		public Indicators.MillaPro MillaPro(ISeries<double> input , string chartSetupTip, NinjaTrader.NinjaScript.Indicators.TradingMode selectedMode, int stopLoss, double stopLoss_To_Profit_Target_Ratio, int maxWaitBars, bool enableDotFlipS3, int s3MinGapBars, int s3MaxGapBars, bool enableDotCrossStrategy, int firstCandleMaxDistance, int alignWindowBars, NinjaTrader.NinjaScript.Indicators.ValidationMode validationModeSelection, bool enableValidationAsEntry, bool useValAsEntry_Opt2_TrendStrengthOnly, bool useValAsEntry_Opt1_CanTradeOnly, bool useValAsEntry_Opt3_Both_LastLegWins, bool useTSFilter, int minBullPctForLong, int minBearPctForShort, bool enableExitAlerts, int exitThreshold, int exitCooldownBars, bool useAutoOW, int manualBreakoutCushionTicks, int manualHoldBarsAfterBreakout, int manualCooldownBarsAfterFlip, bool useLimitPullbackEntry, int pullbackTicks, int uiFontSize)
		{
			return indicator.MillaPro(input, chartSetupTip, selectedMode, stopLoss, stopLoss_To_Profit_Target_Ratio, maxWaitBars, enableDotFlipS3, s3MinGapBars, s3MaxGapBars, enableDotCrossStrategy, firstCandleMaxDistance, alignWindowBars, validationModeSelection, enableValidationAsEntry, useValAsEntry_Opt2_TrendStrengthOnly, useValAsEntry_Opt1_CanTradeOnly, useValAsEntry_Opt3_Both_LastLegWins, useTSFilter, minBullPctForLong, minBearPctForShort, enableExitAlerts, exitThreshold, exitCooldownBars, useAutoOW, manualBreakoutCushionTicks, manualHoldBarsAfterBreakout, manualCooldownBarsAfterFlip, useLimitPullbackEntry, pullbackTicks, uiFontSize);
		}

		public Indicators.AuSuperSmootherFilter AuSuperSmootherFilter(ISeries<double> input , int poles, int period)
		{
			return indicator.AuSuperSmootherFilter(input, poles, period);
		}

	}
}

#endregion
