#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;

#endregion



#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		
		private MillaHedge[] cacheMillaHedge;

		
		public MillaHedge MillaHedge(int tapeMinPrintQty, int tapeWindowSeconds, double minTapeBias, int fontSize, int verticalOffsetRows, bool showAlignmentGauges, bool showHub)
		{
			return MillaHedge(Input, tapeMinPrintQty, tapeWindowSeconds, minTapeBias, fontSize, verticalOffsetRows, showAlignmentGauges, showHub);
		}


		
		public MillaHedge MillaHedge(ISeries<double> input, int tapeMinPrintQty, int tapeWindowSeconds, double minTapeBias, int fontSize, int verticalOffsetRows, bool showAlignmentGauges, bool showHub)
		{
			if (cacheMillaHedge != null)
				for (int idx = 0; idx < cacheMillaHedge.Length; idx++)
					if (cacheMillaHedge[idx].TapeMinPrintQty == tapeMinPrintQty && cacheMillaHedge[idx].TapeWindowSeconds == tapeWindowSeconds && cacheMillaHedge[idx].MinTapeBias == minTapeBias && cacheMillaHedge[idx].FontSize == fontSize && cacheMillaHedge[idx].VerticalOffsetRows == verticalOffsetRows && cacheMillaHedge[idx].ShowAlignmentGauges == showAlignmentGauges && cacheMillaHedge[idx].ShowHub == showHub && cacheMillaHedge[idx].EqualsInput(input))
						return cacheMillaHedge[idx];
			return CacheIndicator<MillaHedge>(new MillaHedge(){ TapeMinPrintQty = tapeMinPrintQty, TapeWindowSeconds = tapeWindowSeconds, MinTapeBias = minTapeBias, FontSize = fontSize, VerticalOffsetRows = verticalOffsetRows, ShowAlignmentGauges = showAlignmentGauges, ShowHub = showHub }, input, ref cacheMillaHedge);
		}

	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		
		public Indicators.MillaHedge MillaHedge(int tapeMinPrintQty, int tapeWindowSeconds, double minTapeBias, int fontSize, int verticalOffsetRows, bool showAlignmentGauges, bool showHub)
		{
			return indicator.MillaHedge(Input, tapeMinPrintQty, tapeWindowSeconds, minTapeBias, fontSize, verticalOffsetRows, showAlignmentGauges, showHub);
		}


		
		public Indicators.MillaHedge MillaHedge(ISeries<double> input , int tapeMinPrintQty, int tapeWindowSeconds, double minTapeBias, int fontSize, int verticalOffsetRows, bool showAlignmentGauges, bool showHub)
		{
			return indicator.MillaHedge(input, tapeMinPrintQty, tapeWindowSeconds, minTapeBias, fontSize, verticalOffsetRows, showAlignmentGauges, showHub);
		}
	
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		
		public Indicators.MillaHedge MillaHedge(int tapeMinPrintQty, int tapeWindowSeconds, double minTapeBias, int fontSize, int verticalOffsetRows, bool showAlignmentGauges, bool showHub)
		{
			return indicator.MillaHedge(Input, tapeMinPrintQty, tapeWindowSeconds, minTapeBias, fontSize, verticalOffsetRows, showAlignmentGauges, showHub);
		}


		
		public Indicators.MillaHedge MillaHedge(ISeries<double> input , int tapeMinPrintQty, int tapeWindowSeconds, double minTapeBias, int fontSize, int verticalOffsetRows, bool showAlignmentGauges, bool showHub)
		{
			return indicator.MillaHedge(input, tapeMinPrintQty, tapeWindowSeconds, minTapeBias, fontSize, verticalOffsetRows, showAlignmentGauges, showHub);
		}

	}
}

#endregion
